#!/usr/bin/env python
#
# balances.py  -  Zope utility to control balances.
#
# $Revision: 1.2 $
#
# Copyright (C) 2014 Jan Jockusch <jan.jockusch@perfact.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# $Id: balances.py,v 1.2 2017-02-08 15:04:00 perfact Exp $

import six
import os.path

from .generic import safe_syscall


def balance_ctl(addr, balancetype, cmd, value=''):
    '''Use this from within zope to obtain remote results.
    '''
    if balancetype not in ('it3000', 'precisa'):
        raise ValueError("Invalid balance type")

    try:
        host, port = addr.split(':')
    except ValueError:
        host, port = addr, 2000

    mod_path = os.path.realpath(__file__ + '/../balancemods')
    interpreter = 'python2' if six.PY2 else 'python3'
    # TODO: rewrite them as modules instead of calling them as subprocesses
    ret = safe_syscall(
        [
            interpreter,
            '%s/%s.py' % (mod_path, balancetype),
            str(host),
            str(port),
            str(cmd),
            str(value)
        ],
        raisemode=True,
    )
    # Convert pickled dictionary back
    return ret
