#!/usr/bin/python
# coding: utf8
#
# SoapPseudoConnection.py - a pseudo db-connection for webservices used in
#     dbconnector.py
#
# Copyright (C) 2017 PerFact Innovation GmbH & Co. KG <info@perfact.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# $Id: dbconnector.py,v 2.10 2013/09/10 13:29:47 perfact Exp perfact $


import perfact.webservice


class SoapPseudoConnection(object):
    ''' This is no db connector but a config for soap calls '''

    def __init__(self, connector, dbtype='', version='1.2', authtype='basic'):
        self.connector = connector
        self.dbtype = dbtype
        self.authtype = authtype
        self.version = version
        # get the credentials from the url
        match = perfact.webservice.credentialsFromUrl(connector)
        self.credentials = None
        if match:
            self.credentials = {}
            self.credentials['username'] = match[0]
            self.credentials['password'] = match[1]
        self.endpoint = perfact.webservice.removeCredentialsFromUrl(
            self.connector)

    def close(self):
        pass
