#!/usr/bin/env python
from M2Crypto.EVP import Cipher
from binascii import unhexlify as h2b
from M2Crypto.util import pkcs5_pad
from os import popen

ENC = 1


def b2h(text):
    erg = ''
    for i in text:
        erg += '%02x'.upper() % ord(i)
    return erg


def docware_encrypt(url, gkey, giv):
    key = pkcs5_pad(h2b(gkey))
    iv = pkcs5_pad(h2b(giv))
    c = Cipher(alg='aes_128_cbc', key=key, iv=iv, op=ENC)
    v = c.update(url)
    v = v + c.final()
    del c
    erg = b2h(v)
    return erg


def docware_decrypt(cipher, gkey, giv):
    key = pkcs5_pad(h2b(gkey))
    iv = pkcs5_pad(h2b(giv))
    c = Cipher(alg='aes_128_cbc', key=key, iv=iv, op=0)
    v = c.update(h2b(cipher))
    v = v + c.final()
    del c
    return v


def docware_call(url):
    fout = popen("/usr/bin/curl -k -s -m 20 '%s'" % (url))
    output = fout.read()
    retval = fout.close()
    if retval:
        return ('Fehler, der Docware-Server ist leider '
                'momentan nicht verfuegbar')
    return output
