#!/usr/bin/env python
# -*- coding: utf-8 -*-

import unittest

from .. import ical
from datetime import datetime
import re


class TestICal(unittest.TestCase):

    demo_vcard_data = {
        'lastname': 'Mustermann',
        'firstname': 'Max',
        'salutation': 'Herr',
        'acadtitle': 'Dr.',
        'company': 'Musterfirma',
        'department': 'Mitarbeiter des Monats',
        'phone_numbers': [
            ('work', '+49 000 111222333'),
            ('home', '+49 555 667788'),
        ],
        'mail_addresses': [
            'max.mustermann@musterfirma.de',
            'max@mustermann.de'
        ],
        'lang': 'de',
        'locale': 'DE',
    }

    demo_timestamp = datetime.now().strftime("%Y%m%dT%H%M%S")

    demo_vcard_return = (
        'BEGIN:VCARD\n'
        'VERSION:4.0\n'
        'REV:{timestamp}\n'
        'KIND:individual\n'
        'N:Mustermann;Max;;Herr Dr.;\n'
        'FN:Dr. Max Mustermann\n'
        'LANG:de-DE\n'
        'ORG:Musterfirma\n'
        'TITLE:Mitarbeiter des Monats\n'
        'EMAIL;PREF=1:max.mustermann@musterfirma.de\n'
        'EMAIL;PREF=2:max@mustermann.de\n'
        'TEL;VALUE=uri;PREF=1;TYPE="work":+49 000 111222333\n'
        'TEL;VALUE=uri;PREF=2;TYPE="home":+49 555 667788\n'
        'END:VCARD'
    ).format(timestamp=demo_timestamp)

    # test vcard formatting
    def test_make_vcard(self):
        ret = ical.make_vcard(data=self.demo_vcard_data)

        # adjust result to match the timestamp
        ret = re.sub(
            r'REV:[\d\w]+',
            'REV:{}'.format(self.demo_timestamp),
            ret
        )

        assert ret == self.demo_vcard_return
