#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# test_pseudoconnection.py  -  Unittests for SoapPseudoConnection
#
# $Revision: 1.0 $
#
# Copyright (C) 2015 Jens Hinghaus <jens.hinghaus@perfact.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import unittest
from ..daemondatasources.SoapPseudoConnection import SoapPseudoConnection


class PseudoConnectionTC(unittest.TestCase):

    def test_http_without_creds(self):
        connectstring = 'http://www.perfact.de/index.html'
        should_endpoint = 'http://www.perfact.de/index.html'
        should_creds = None
        con = SoapPseudoConnection(connector=connectstring, dbtype='soap')
        self.assertEqual(should_endpoint, con.endpoint)
        self.assertEqual(should_creds, con.credentials)

    def test_http_with_creds(self):
        connectstring = 'http://foo:bar@www.perfact.de/index.html'
        should_endpoint = 'http://www.perfact.de/index.html'
        should_creds = {'username': 'foo', 'password': 'bar'}
        con = SoapPseudoConnection(connector=connectstring, dbtype='soap')
        self.assertEqual(should_endpoint, con.endpoint)
        self.assertEqual(should_creds, con.credentials)

    def test_https_without_creds(self):
        connectstring = 'https://www.perfact.de/index.html'
        should_endpoint = 'https://www.perfact.de/index.html'
        should_creds = None
        con = SoapPseudoConnection(connector=connectstring, dbtype='soap')
        self.assertEqual(should_endpoint, con.endpoint)
        self.assertEqual(should_creds, con.credentials)

    def test_https_with_creds(self):
        connectstring = 'https://foo:bar@www.perfact.de/index.html'
        should_endpoint = 'https://www.perfact.de/index.html'
        should_creds = {'username': 'foo', 'password': 'bar'}
        con = SoapPseudoConnection(connector=connectstring, dbtype='soap')
        self.assertEqual(should_endpoint, con.endpoint)
        self.assertEqual(should_creds, con.credentials)


if __name__ == '__main__':
    unittest.main()
