from . import generic


def not_implemented(*args, **kwargs):
    raise NotImplementedError


def mod_version(context):
    if hasattr(context, 'aq_explicit'):
        c = getattr(context.aq_explicit, 'MOD_NOTES', None)
    else:
        c = getattr(context, 'MOD_NOTES', None)
    if not c:
        return ''

    # We know "MOD_NOTES" is of type File
    data = generic.read_pdata(c)

    try:
        v = data.split('\n', 1)[0].strip()
    except Exception:
        return ''

    # Remove the string Version"
    parts = v.split()
    if not parts:
        return ''
    if parts[0].startswith('V'):
        parts.pop(0)
    v = parts[0]

    return v


def mod_versions_data(context):
    '''Collects data to be displayed by mod_versions.

    Input: None

    Environment: The context should contain one or more
    MOD_SOURCE_<version> files, and a MOD_NOTES file. All of these are
    optional.

    Output: A mapping object with all entries needed by mod_versions. For
    a complete list of keys, see below.

    Side effects: None
    '''
    versions = [a for a in context.objectValues('File')
                if a.id().startswith('MOD_SOURCE_')]

    versions.sort(key=lambda a: a.id(), reverse=True)

    ret = {
        'current_version': mod_version(context),
        'versions': versions,
    }

    return ret


def mod_notes_data(context):
    if hasattr(context, 'aq_explicit'):
        c = getattr(context.aq_explicit, 'MOD_NOTES', None)
    else:
        c = getattr(context, 'MOD_NOTES', None)

    if not c:
        return ''

    data = generic.read_pdata(c)
    return data


def mod_title(context):
    parents = context.layout_crumb_list()
    parents.reverse()
    for parent in parents:
        v = mod_version(context=parent)
        if v:
            txt = parent.layout_title() + ' ' + v
            return txt
    return ''


mod_version_commit = not_implemented
mod_versions_diff = not_implemented
mod_notes_new = not_implemented
mod_read = not_implemented
mod_write = not_implemented
