import unittest
from perfact.generic import deep_update, same_type


class TestGeneric(unittest.TestCase):

    def test_deep_update(self):
        d1 = {
            'replace_me_with_dict': 3,
            'foo': 'bar',
            'numbers': {
                'negatives': {'one': -1, 'three': -3, 'five': -5, },
                'one': 1,
                'two': 2,
                'three': 3,
                'four': 4,
            },
        }
        d2 = {
            'replace_me_with_dict': {'a': 1, 'b': 2},
            'foo': 'rab',
            'numbers': {
                'negatives': {'two': -2, 'four': -4, 'six': -6, },
                'five': 5,
                'six': 6,
                'seven': 7,
            },
        }
        expectation = {
            'replace_me_with_dict': {'a': 1, 'b': 2},
            'foo': 'rab',
            'numbers': {
                'negatives': {
                    'one': -1,
                    'two': -2,
                    'three': -3,
                    'four': -4,
                    'five': -5,
                    'six': -6,
                    },
                'one': 1,
                'two': 2,
                'three': 3,
                'four': 4,
                'five': 5,
                'six': 6,
                'seven': 7,
            },
        }
        merged_dict = deep_update(d1, d2)
        self.assertDictEqual(expectation, merged_dict)

    def test_same_type(self):
        self.assertTrue(same_type(123, 456))
        self.assertFalse(same_type(123, 4.56))
        self.assertTrue(same_type([1, 2, 3], list((1, ))))
        self.assertFalse(same_type([1, 2, 3], {}))


'''
Doctests removed from generic to keep the documentation strings clean.

These tests increase the coverage of the main module adding corner cases.

    Handling different things that evaluate as "False":
    >>> from ..generic import dict_view
    >>> (dict_view(['', None, 0, 0.0, False]) ==
    ... u'<ol>\\n <li></li>\\n <li>None</li>\\n <li>0</li>\\n'
    ... u' <li>0.0</li>\\n <li>False</li>\\n</ol>\\n')
    True

    Handling an error with a type that cannot be displayed:
    >>> dict_view([(lambda a: a+2), ''])
    Traceback (most recent call last):
        ...
    AssertionError: Type could not be determined for ...

    Handling empty lists:
    >>> dict_view([]) == u'<ol>\\n</ol>\\n'
    True

    Handling mixed lists of dictionaries and other types:
    >>> (dict_view([{'a': 1, 'dict': 2}, 'not_a_dict']) ==
    ...  u'<ol>\\n <li><dl>\\n <dt>a</dt><dd>1</dd>\\n'
    ...  u' <dt>dict</dt><dd>2</dd>\\n</dl>\\n</li>\\n'
    ...  u' <li>not_a_dict</li>\\n</ol>\\n')
    True

    Handling recursive tables:
    >>> base_dict = {'a': 1, 'dict': 2}
    >>> lines1 = [dict(base_dict) for counter in range(2)]
    >>> lines2 = [dict(base_dict) for counter in range(2)]
    >>> lines1[0]['a'] = lines2
    >>> (dict_view(lines1) ==
    ...  u'<table> <tr> <th> a </th> <th> dict </th> </tr>\\n'
    ...  u'<tr> <td> '
    ...  u'<table> <tr> <th> a </th> <th> dict </th> </tr>\\n'
    ...  u'<tr> <td> 1 </td> <td> 2 </td> </tr>\\n'
    ...  u'<tr> <td> 1 </td> <td> 2 </td> </tr></table> '
    ...  u'</td> <td> 2 </td> </tr>\\n'
    ...  u'<tr> <td> 1 </td> <td> 2 </td> </tr></table>')
    True
    >>> (dict_view(lines1, recursive_tables=False) ==
    ...  u'<ol>\\n <li><dl>\\n '
    ...  u'<dt>a</dt><dd><table> <tr> <th> a </th> <th> dict </th> </tr>\\n'
    ...  u'<tr> <td> 1 </td> <td> 2 </td> </tr>\\n'
    ...  u'<tr> <td> 1 </td> <td> 2 </td> </tr></table></dd>\\n '
    ...  u'<dt>dict</dt><dd>2</dd>\\n</dl>\\n'
    ...  u'</li>\\n '
    ...  u'<li><dl>\\n <dt>a</dt><dd>1</dd>\\n '
    ...  u'<dt>dict</dt><dd>2</dd>\\n</dl>\\n</li>\\n</ol>\\n')
    True

'''
