import doctest
import unittest
import perfact.http_protocol


def load_tests(loader, tests, ignore):
    tests.addTests(doctest.DocTestSuite(perfact.http_protocol))
    tests.addTests(unittest.makeSuite(TestHTTP))
    return tests


class TestHTTP(unittest.TestCase):

    def test_map_routing(self):
        routes = [
            {'spec': r'/(?P<id>\d+)/action/(?P<action>\S+).*',
             'method': 'action_handler'},
            {'spec': r'/(?P<id>\d+).*',
             'method': 'get_handler'},
            {'spec': r'/.*',
             'method': 'root_handler'},
        ]

        handler = perfact.http_protocol.map_routing(
            ['hallo'], routes)['route']['method']
        self.assertEqual(handler, 'root_handler')

        routing_res = perfact.http_protocol.map_routing(
            ['123'], routes)
        self.assertEqual(routing_res['route']['method'], 'get_handler')
        self.assertEqual(routing_res['params']['id'], '123')

        routing_res = perfact.http_protocol.map_routing(
            ['123', 'action', 'test'], routes)
        self.assertEqual(routing_res['route']['method'], 'action_handler')
        self.assertEqual(routing_res['params']['id'], '123')
        self.assertEqual(routing_res['params']['action'], 'test')

        self.assertRaises(
            NotImplementedError,
            perfact.http_protocol.map_routing,
            ['test'], [{'spec': r'/action'}]
        )

        self.assertRaises(
            AssertionError,
            perfact.http_protocol.map_routing,
            ['test'], [{'spec': r'(?P<id>\d+)'}]
        )

        routes = [{
            'spec': r'/(?P<no_illegals>[^/%#_]+)/test',
            'method': 'none',
        }]

        self.assertRaises(
            NotImplementedError,
            perfact.http_protocol.map_routing,
            ['perfectly_okay', 'test'], routes
        )
