# PerFact Python Modules

## Notes for perfact.performancemeter

Because PostgreSQL has changed the definition of the view `pg_stat_activity`
across major releases, we need a compatibility view in the database.

You must initialize this view by defining it in the database for user postgres
according to your PostgreSQL version:

PostgreSQL 8

    create or replace view pf_measure_activity as
    select
      procpid as pid,
      query_start as query_start,
      current_query as query,
      waiting as waiting
    from pg_stat_activity;

PostgreSQL 9

    create or replace view pf_measure_activity as
    select
      pid as pid,
      query_start as query_start,
      query as query,
      waiting as waiting
    from pg_stat_activity;

PostgreSQL 10

    create or replace view pf_measure_activity as
    select
      pid as pid,
      query_start as query_start,
      query as query,
      (wait_event_type is not null and state != 'idle') as waiting
    from pg_stat_activity;

When using perfact.performancemeter on Ubuntu-14.04LTS, commands for recovering
zope and zeo have to be configured as described in
`/etc/perfact/measure/config.py`
