# PerFact Python Modules

Requirements (when installed as debian package):
- Debian based linux distribution
-

Maintainers:
Ján Jockusch <jan.jockusch@perfact.de>
Viktor Dick <viktor.dick@perfact.de>


# Installation

A stable build is available via the perfact debian package repository and can
be installed using aptitude.

Development packages can be installed using dpkg.


# Testing

**Attention!** Tox testsuite is not yet ready for testing due to build issues

## During development

Use pytest.

```
sudo apt-get install python3-pytest
```

Call a test, e.g.:

```
pytest-3 perfact/tests/test_ovpn.py
```

Expect import errors like:

```
E   ModuleNotFoundError: No module named 'markdown'
```

Install the missing package:

```
sudo apt-get install python3-markdown
```

Check [this](debian/control) for a full list of dependencies if you don't want
to discover them using the steps shown above.

If everything worked fine the test output should be something like:

```
$ pytest-3 perfact/tests/test_ovpn.py
========================================== test session starts ==========================================
platform linux -- Python 3.6.9, pytest-3.3.2, py-1.5.2, pluggy-0.6.0
rootdir: /home/lars/something/something/little_bit_of_love/python-perfact, inifile: tox.ini
collected 3 items                                                                                       

perfact/tests/test_ovpn.py ...                                                                    [100%]

======================================= 3 passed in 0.07 seconds ========================================
```


## Final test

The final test is done using the [packages-builder](https://git.perfact.de/SystemTools/packages-builder) to create
the correct environment for python-perfact.

Check [this](https://git.perfact.de/SystemTools/packages-builder#building-packages) for a guide on
how to build and therefore test your branch.

Example ( after installation ):

```
$ ./bin/run-docker.sh --systems "focal" --packages python-perfact \
    --build-branch <YOUR-BRANCH-HERE>
```

This test **must** be passed before merging into the master.
