#!/usr/bin/python

'''
This script will communicate with the balance.
The given command will be transfered and in return the result will be returned.

This script is specially made for this balances type:
Dini Argeo DFW-ATEX GDIO-1

Several commands can be processed.
'''
import socket
import time
import sys
from perfact.generic import to_bytes, to_string


def readdata():
    if debug:
        print("DEBUG Entered function readdata")
    data = b''
    while True:
        try:
            received_bit = soc.recv(1)
            if received_bit in b'\r\n':
                break
            data += received_bit

            if debug:
                print(('DEBUG data: %s' % (data)))
        except Exception:
            pass
    data = to_string(data)
    result = []

    # parsing
    lines = data.split('\n')
    for line in lines:
        # line contains a ',' before unit. TODO: delete last comma
        fulline = line
        g = False
        o = False

        line.rstrip('\r')
        line.lstrip(' ')

        line = line.replace(',', ' ')
        line = line.replace('US', '')

        if '+' in line:
            line = line.split('+')[1]

        if 'GS' in line:
            line = line.replace('GS', '')

        if 'NT' in line:
            line = line.replace('NT', '')

        if 'o' in line:
            o = True

        line = line.replace('o', '')

        if 'ST' in line:
            g = True

        line = line.replace('ST', '')

        try:
            weight = float(line.replace(' ', ''))
        except ValueError:
            weight = None

        result.append(
            {
                'weight': line.strip(' '),
                'balanced': g,
                'signal_o': o,
                'fulline': fulline,
                'fweight': weight,
                # 'mtunit': fullline[-2:]
            }
        )

    balance_output = result[-1]  # get only latest balance output
    for entry in result:
        if entry != balance_output:
            balanced = False
        else:
            balanced = True

    result = result[-1]

    if not balanced:
        result = {
            'error': 'Weight is not balanced'
        }

    return result


def communicate_argeo(command, value=''):
    if debug:
        print("DEBUG Entered function communicate_argeo")

    # valid commands
    commands = [
        'READ',
        'TARE',
        'ZERO',
    ]

    if command not in commands:
        return {
            'error': 'No valid command'
        }

    # read weight output
    if command == 'READ':
        if debug:
            print('DEBUG Entered command READ')
        soc.send(to_bytes('READ\r\n'))

        # we want only balanced data!
        balanced = False
        num_retries = 0  # we need a timeout just for secure
        while not balanced or num_retries <= 10:
            data = readdata()  # we read the data
            num_retries = num_retries + 1
            if data['balanced'] is True:  # check if it's balanced
                balanced = True  # pass if it's balanced
        return data

    # set weight to null
    if command == 'ZERO':
        if debug:
            print('DEBUG Entered command ZERO')
        soc.send(to_bytes('ZERO\r\n'))
        print("Set weight to null")

    # tare balance
    if command == 'TARE':
        if debug:
            print('DEBUG Entered command TARE')
        if value:
            soc.send(to_bytes('TARE\r\n'))
            print('TARE command sent with value')
        else:
            soc.send(to_bytes('TARE\r\n'))
            print('TARE command sent without specific value')
        print("Set tare")


if __name__ == '__main__':
    '''
    If called directly (e.g. via ssh for remote readouts) pass
    command line options as command and value.
    '''

    start = time.time()
    reset = 0
    hostname = ''
    port = 0

    if len(sys.argv) < 4:
        print(
            "Missing argument. "
            "Usage: <driver>.py host port command [ value ]"
        )
        sys.exit()

    me = sys.argv.pop(0)
    hostname = sys.argv.pop(0)
    port = int(sys.argv.pop(0))
    command = sys.argv.pop(0)

    if 'debug' in sys.argv:
        debug = True
    else:
        debug = False

    if debug:
        print(("DEBUG Me: %s" % (me)))
        print(("DEBUG Hostname: %s" % (hostname)))
        print(("DEBUG Port: %s" % (port)))
        print(("DEBUG Command: %s" % (command)))

    try:
        value = sys.argv.pop(0)
    except Exception:
        value = ''

    socket.setdefaulttimeout(1)
    soc = socket.socket()

    soc.setsockopt(
        socket.SOL_SOCKET,
        socket.SO_REUSEADDR,
        1
    )

    try:
        soc.connect((
            hostname,
            port
        ))  # this needs to be a tuple
    except Exception:
        print('Connection can not be established')

    res_argeo = communicate_argeo(
        command=command,
        value=value
    )

    print(res_argeo)
