#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# test_datasourceProvider.py  -  Unittests for datasourceProvider.py
#
# $Revision: 1.0 $
#
# Copyright (C) 2016 Jens Hinghaus <jens.hinghaus@perfact.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

from ..daemondatasources import datasourceProvider
import unittest


class DsProviderTC(unittest.TestCase):

    def test_soap(self):
        ds = datasourceProvider.createDS('soap', 'http://example.com/wsa')
        self.assertEqual('http://example.com/wsa',
                         ds.endpoint, 'wrong endpoint')

    def test_dbdummy(self):
        ds = datasourceProvider.createDS('dbdummy', 'some_connectstring')
        self.assertEqual('dbdummy', ds.dbtype)

    def test_unknown(self):
        ''' Test exception behaviour '''
        with self.assertRaises(datasourceProvider.dsException):
            datasourceProvider.createDS('foo', 'random stuff')

    def test_pyodbc(self):
        ''' Test default behaviour for pyodbc connector '''
        ds = datasourceProvider.createDS('pyodbc', 'connect_string')
        self.assertEqual('pyodbc', ds.dbtype)

    def test_pyodbc_oracle(self):
        ''' Test behaviour for pyodbc connector with oracle flavour '''
        ds = datasourceProvider.createDS('pyodbc_oracle', 'connect_string')
        self.assertEqual('pyodbc_oracle', ds.dbtype)
        self.assertEqual('DUAL', ds.phantom_table)


if __name__ == '__main__':
    unittest.main()
