#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# test_htmlprocess.py  -  Test html processing in generic.py
#
# $Revision: 1.0 $
#
# Copyright (C) 2015 Jens Hinghaus <jens.hinghaus@perfact.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import unittest
from .. import generic


class html_processing_tc(unittest.TestCase):

    def test_simple(self):
        ''' most simple html snippet'''
        source = '<strong>foo<br/>bar</string>'
        should = 'foobar'
        res = generic.html_process(source)
        self.assertEqual(should, res)

    def test_morecomplex(self):
        ''' test a more complex snippet '''
        source = '''<strong>Servername<br/>Txy Routinecheck</strong>
 (geschlossen)<br/><h4>Problembeschreibung</h4>
<p>Im Zuge des Routinechecks wurde eine hohe Auslastung von /vol/postgresql
 festgestellt (93%).</p>
<h4>Ma&szlig;nahme</h4>
<p>&nbsp;F&uuml;r die Volumegroup stehen weitere 1,6 TB zur Verf&uuml;gung.
 Daher kann /vol/postgresql erweiter werden.</p>
<p>Nachfolgeticket f&uuml;r eine Erweiterung wurde generiert.</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p><br/><br/><strong>Zeitaufwand:</strong> 1h <br/><strong>In SLA
 enthalten</strong><br/><br/><strong>Arbeitspositionen:</strong><br/>-<br/>
 <br/>---<br/><strong>servera/b<br/>Txy Routinecheck</strong> (geschlossen)
 <br/><p>Routinecheck erfolgreich durchgef&uuml;hrt.</p>
<p>Keine Auff&auml;lligkeiten festgestellt.</p>
<p>&nbsp;</p>
<h4>Sicherheitsupdates stehen bereit</h4>
<p><br/>Das Einspielen des Updates nimmt ca. xh in Anspruch.</p>
<p>Die erwartete Downtime durch das Einspielen des Updates
 betr&auml;gt 0.5h.</p>
<p><br/>(Es kann zu kurzen Unterbrechungen beim Schwenken der Dienste
 kommen)<br/>&nbsp;Bitte setzen Sie sich zur Beauftragung des Updates bis
  zum 13.06.17 <br/>&nbsp; mit uns in Verbindung.)</p><br/><br/>
  <strong>Zeitaufwand:</strong> 1h <br/><strong>In SLA enthalten</strong><br/>
  <br/><strong>Arbeitspositionen:</strong><br/>-<br/><br/>---<br/>
  <strong>seclogon-cn<br/>Txy Routinecheck</strong> (geschlossen)<br/><p>
  <strong>Routinecheck erfolgreich durchgef&uuml;hrt.</strong></p>
<p>Keine Auff&auml;lligkeiten festgestellt.</p><br/><br/>'''
        tags = ['<p>', '</p>', '<h4>', '</h4>',
                '<strong>', '</strong>', '<br/>']
        should = source
        for tag in tags:
            should = should.replace(tag, '')
        res = generic.html_process(source)
        self.assertEqual(should, res)

    def test_recursionfail(self):
        ''' test a document that would break with the old implementation
        more is still failing '''
        source = ('line<BR>' * 1500) + 'foo'
        should = 'line' * 1500 + 'foo'
        res = generic.html_process(source)
        self.assertEqual(should, res)
