# -*- coding: utf-8 -*-

from setuptools import setup


setup(
    name='PerFact Python Modules',
    version='22.2.6',
    description='Modules with helper functions for PerFact Web Apps',
    long_description='''These modules are useful for expanding the capabilities of Zope
applications and command line utilities.''',
    author='Ján Jockusch et.al.',
    author_email='devel@perfact.de',
    packages=[
        'perfact',
        'perfact.daemondatasources',
        'perfact.daemondatasources.providers',
        'perfact.balancemods',
        # This package is only needed to make tox tests work
        'perfact.tests',
    ],
    package_data={
        'perfact': [
            'assets/file/*',
            'assets/data/*',
            'assets/mail/*',
            'assets/tests/*',
        ],
    },
    # XXX "script" directive removed altogether, to let debian take care of
    # things
    license='GPLv2',
    platforms=['Linux', ],
    # At least list everything to be able to import perfact.generic, so we can
    # install into a virtualenv.
    install_requires=[
        'six',
        'html2text',
        'markdown',
        'pyyaml',
    ],
    # XXX This directive interferes with unit testing with tox.
    # test_suite="perfact.tests",
)
